;;;   EP.lsp   Version 1.0
;;;   (C) Copyright 1988-1992 by Autodesk, Inc.
;;;  
;;;   This program is copyrighted by Autodesk, Inc. and is  licensed
;;;   to you under the following conditions.  You may not distribute
;;;   or  publish the source code of this program in any form.   You
;;;   may  incorporate this code in object form in derivative  works
;;;   provided  such  derivative  works  are  (i.) are  designed and
;;;   intended  to  work  solely  with  Autodesk, Inc. products, and
;;;   (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
;;;   1988-1992 by Autodesk, Inc."
;;;
;;;   AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
;;;   AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
;;;   CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
;;;   DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
;;;   UNINTERRUPTED OR ERROR FREE.
;;; 
;;;   By Troy Davis / revised by Steve McCall
;;;   Autodesk, Inc.  May 1, 1990
;;;---------------------------------------------------------------------------
;;; DESCRIPTION
;;; 
;;;   EP.LSP  (Enter Point) --  prompts the user for coordinate point entries;
;;;   makes it easy to distinguish between WCS or UCS Absolute or
;;;   Relative - or Cartesian, Cylindrical or Spherical entries.
;;;   (Quick, what is  "@*123<45,67" ???).  You can also reset the
;;;   "lastpoint" system variable for Relative entries.
;;;
;;;   After this Lisp function is loaded <(load "ep")>, it can be
;;;   used anytime AutoCAD requires a point. Just enter "(ep)"
;;;   at the point prompt.
;;;
;;;   You will then be prompted:
;;;
;;;   Exit/World/Absolute to UCS origin/Set lastpoint/<Relative to lastpoint>:
;;;
;;;   Enter a letter:  e, w, a, s, or  r<default>, and follow the
;;;   prompts. "w" (World) also allows Absolute or Relative.
;;;             
;;;   The function then assembles the proper point entry, which is
;;;   given to the AutoCAD prompt and echoed to the screen so you can
;;;   see how that point would be specified.
;;;
;;;   You can enter "E" (Exit) at any time to return to normal point
;;;   entry; cancelling the function will also cancel the parent
;;;   command.  All variables are local.  This function cannot be
;;;   used to respond to an AutoLISP prompt.
;;;
;;;---------------------------------------------------------------------------


(defun myerr (msg)
   (if (/= msg "Function cancelled")
      (princ (strcat "\nError: " msg))
   )
   (setq *error* olderr)
   (princ)
)
(defun ep ( / fp1 fp2 fp3 fp4 fp5 fp6 fp7 fp8 fp9 fp10)
  (setq olderr *error*
        *error* myerr
  )
  (while 
    (not 
      (=
        (progn 
          (initget "Exit World Absolute Set Relative")
          (setq fp1 (getkword (strcat
            "\nExit/World/Absolute to UCS origin/"
            "Set lastpoint/<Relative to lastpoint>: ")))
        )
        "Exit"
      )
    )
    (if (= fp1 "Set")
      (setvar "LASTPOINT" (getpoint "Reference point: "))
      (progn
        (setq fp10 "")
        (if (= fp1 "World")
          (progn
            (initget "Absolute Relative")
            (setq fp10 "World"
                  fp2 (getkword 
                    "Absolute to World origin/<Relative to lastpoint>: ")
            )
            (if (= fp2 "Absolute")
               (setq fp3 "*" fp4 (trans (list 0.0 0.0 0.0) 0 1))
               (setq fp3 "@*" fp4 (getvar "lastpoint"))
            )
          )
          (if (= fp1 "Absolute")
            (setq fp3 "" fp4 (list 0.0 0.0 0.0))
            (setq fp3 "@" fp4 (getvar "lastpoint"))
          )
        )
        (initget "Xyz Spherical Cylindrical")
        (setq fp5 (getkword "Xyz/Cylindrical/<Spherical>: "))
        (initget 1)
        (if (= fp5 "Cylindrical")
          (progn
            (setq fp6 (getdist fp4 "Enter distance in XY plane: "))
            (initget 1) (setq fp7 (getangle fp4 "Enter angle from X: "))
            (initget 1) (setq fp8 (getdist fp4 "Enter displacement along Z: "))
            (setq fp9 (strcat fp3 (rtos fp6) "<" (angtos fp7) "," (rtos fp8)))
          )
          (if (= fp5 "Xyz")
            (progn
              (setq fp6 (getdist (strcat 
                "Enter displacement along " fp10 " X axis: ")))
              (initget 1) (setq fp7 (getdist (strcat 
                "Enter displacement along " fp10 " Y axis: ")))
              (initget 1) (setq fp8 (getdist (strcat 
                "Enter displacement along " fp10 " Z axis: ")))
              (setq fp9 (strcat fp3 (rtos fp6) "," 
                                    (rtos fp7) "," (rtos fp8)))
            )
            (progn
              (setq fp6 (getdist fp4 "Enter 3D Distance: "))
              (initget 1) (setq fp7 (getangle fp4 "Enter Angle from X: "))
              (initget 1) (setq fp8 (getangle fp4 
                "Enter Angle from XY plane: "))
              (setq fp9 (strcat fp3 (rtos fp6) "<" (angtos fp7) "<" 
                                                   (angtos fp8)))
            )
          )
        )
        (command fp9)
      )
    )
  )
  (setq *error* olderr)
  (princ)
)
(princ "\n\tEp loaded.  Start command with (ep) when a point is requested.")
(princ)
